/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PlayerSelector {
    public static PlayerSelector of(Object o) {
        if (o instanceof ServerPlayerJS) {
            ServerPlayerJS sp = (ServerPlayerJS)o;
            return PlayerSelector.identity(sp);
        }
        if (o instanceof Player) {
            Player p = (Player)o;
            return PlayerSelector.mc(p);
        }
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return PlayerSelector.uuid(uuid);
        }
        String name = Objects.toString(o, "").trim().toLowerCase();
        if (name.isEmpty()) {
            return PlayerSelector.identity(null);
        }
        UUID uuid = UUIDWrapper.fromString((Object)name);
        if (uuid != null) {
            return PlayerSelector.uuid(uuid);
        }
        return PlayerSelector.name(name).or(PlayerSelector.fuzzyName(name));
    }

    @Nullable
    public ServerPlayerJS getPlayer(Map<UUID, ? extends ServerPlayerDataJS> var1);

    public static PlayerSelector identity(ServerPlayerJS player) {
        return knownPlayers -> player;
    }

    public static PlayerSelector mc(Player player) {
        return PlayerSelector.uuid(player.m_142081_());
    }

    public static PlayerSelector uuid(UUID uuid) {
        return knownPlayers -> {
            ServerPlayerDataJS data = (ServerPlayerDataJS)knownPlayers.get(uuid);
            return data == null ? null : data.getPlayer();
        };
    }

    public static PlayerSelector name(String name) {
        return knownPlayers -> {
            for (ServerPlayerDataJS p : knownPlayers.values()) {
                if (!p.getName().toLowerCase(Locale.ROOT).equals(name)) continue;
                return p.getPlayer();
            }
            return null;
        };
    }

    public static PlayerSelector fuzzyName(String name) {
        return knownPlayers -> {
            for (ServerPlayerDataJS p : knownPlayers.values()) {
                if (!p.getName().toLowerCase(Locale.ROOT).contains(name)) continue;
                return p.getPlayer();
            }
            return null;
        };
    }

    default public PlayerSelector or(PlayerSelector fallback) {
        return knownPlayers -> {
            ServerPlayerJS p = this.getPlayer(knownPlayers);
            return p == null ? fallback.getPlayer(knownPlayers) : p;
        };
    }
}

